package com.wsn640.slidewaydatainterface.service.impl;

import com.wsn640.slidewaydatainterface.dao.SubscriberDao;
import com.wsn640.slidewaydatainterface.entity.Subscriber;
import com.wsn640.slidewaydatainterface.service.SubscriberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SubscriberServiceImpl implements SubscriberService {

    @Autowired
    SubscriberDao subscriberDao;

    @Override
    public String registerSubscriber(String name, String ipPort) {
        Subscriber subscriber = new Subscriber(ipPort, name);
        boolean result = subscriberDao.insertSubscriber(subscriber);
        if(result){
            return " " + subscriber.getId();
        }
        return "register Failed";
    }

    @Override
    public List<Subscriber> getSubscriberList() {
        return subscriberDao.querySubscriberList();
    }

//    @Override
//    public Subscriber searchSubcriberByIpPort(String ipPort) {
//        return null;
//    }

    @Override
    public String deleteSubscriber(Integer id) {
        Subscriber subscriber = subscriberDao.querySubscriber(id);
        boolean restult = subscriberDao.deleteSubscriber(subscriber);
        if(restult){
            return "Logout Success";
        }
        return "Logout Failed";
    }
}
