package com.wsn640.slidewaydatainterface.dao;

import com.wsn640.slidewaydatainterface.entity.FileInfo;
import org.apache.ibatis.annotations.Param;
import org.mybatis.spring.annotation.MapperScan;

import java.util.Date;
import java.util.List;


public interface FileInfoDao {

    FileInfo queryFileInfoById(int id);

    FileInfo queryFileInfoByFileName(String filename);

    List<FileInfo> queryFileInfoList();

    List<String> queryFileInfoListOnlyFilename();

    List<FileInfo> queryFileInfoListByDate(@Param("start")Date st, @Param("end")Date ed);

    List<FileInfo> queryFileInfoListByFence(int fence);

    boolean insertFileInfo(FileInfo fileInfo);

    boolean updateFileInfoById(FileInfo fileInfo);

    boolean updateFileInfoByFilename(FileInfo fileInfo);

    boolean deleteFileInfo(FileInfo fileInfo);


}
