package com.wsn640.slidewaydatainterface.dao;

import com.wsn640.slidewaydatainterface.entity.FileInfo;
import org.junit.Ignore;
import org.junit.Test;

import org.junit.platform.commons.util.CollectionUtils;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.File;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@RunWith(SpringRunner.class)
@SpringBootTest
public class FileInfoDaoTest {

    @Autowired
    private  FileInfoDao fileInfoDao;

    @Test
    public void queryFileInfoById() {
    FileInfo fileInfo= new FileInfo();
     fileInfo=fileInfoDao.queryFileInfoById(90);
     System.out.println(fileInfo.getId());
    }

    @Test
    public void queryFileInfoByFileName() {
        FileInfo fileInfo= new FileInfo();
        fileInfo=fileInfoDao.queryFileInfoById(90);
        System.out.println(fileInfo.getId());
    }

    @Test
    public void queryFileInfoList() {
        List<FileInfo> fileInfoList = fileInfoDao.queryFileInfoList();
        System.out.println(fileInfoList.size());
        for (FileInfo fileInfo: fileInfoList
             ) {
            System.out.println(fileInfo.getId());
            System.out.println(fileInfo.getFence());
            System.out.println(fileInfo.getInDateTime());
            System.out.println(fileInfo.getIsDelete());
            System.out.println(fileInfo.getFileType());
        }
    }

    @Test
    public void queryFileInfoListByDate() {
        FileInfo fileInfo= new FileInfo();
        Date start = new Date();
        Date end = new Date();
        GregorianCalendar st_gc = new GregorianCalendar();
        st_gc.set(Calendar.YEAR,2020);//设置年
        st_gc.set(Calendar.MONTH, 5);//这里0是1月..以此向后推
        st_gc.set(Calendar.DAY_OF_MONTH, 3);//设置天
        start = st_gc.getTime();
        GregorianCalendar ed_gc = new GregorianCalendar();
        ed_gc.set(Calendar.YEAR,2020);//设置年
        ed_gc.set(Calendar.MONTH, 5);//这里0是1月..以此向后推
        ed_gc.set(Calendar.DAY_OF_MONTH, 7);//设置天
        end = ed_gc.getTime();
        System.out.println(start);
        System.out.println("start= "+ start);
        System.out.println("end= "+ end);
        List<FileInfo> fileList = fileInfoDao.queryFileInfoListByDate(start, end);
        System.out.println(fileList.size());
        for (FileInfo file: fileList
        ) {
            System.out.println(file.getId());
        }


    }

    @Test
    @Ignore
    public void queryFileInfoListByFence() {
    }

    @Test
    public void insertFileInfo1() {
        System.out.println(TimeZone.getDefault()); //输出当前默认时区
        final TimeZone zone = TimeZone.getTimeZone("GMT+8"); //获取中国时区
        TimeZone.setDefault(zone); //设置时区
        System.out.println(TimeZone.getDefault()); //
        // 上面是让时间正常
        String path = "G:\\easyFarm\\一桂\\vue\\vue-manage-system-4.0.1\\src\\assets\\img2";
        String[] fileList = new File(path).list();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

        Date date1 = new Date();
        System.out.println(date1);
        FileInfo fileInfo = new FileInfo();
        for (String fileNnameTmp: fileList) {
            String prefix = fileNnameTmp.substring(0, fileNnameTmp.lastIndexOf("."));
            int num = 1;
            int type =1;
            Date date = new Date();;

            String reserve = "000000" +
                    "";
            System.out.println(prefix + " " + prefix.length() + " " + date + " " + num + " " + type +  " " + reserve);

            fileInfo.setFilename(prefix);

            fileInfo.setFileType(1);
            fileInfo.setInDateTime(date1);
            fileInfo.setFence(1);
            fileInfo.setIsDelete(0);
            fileInfoDao.insertFileInfo(fileInfo);
            System.out.println(fileInfoDao.insertFileInfo(fileInfo));

        }

    }

    @Test
    public void insertFileInfo() {
        System.out.println(TimeZone.getDefault()); //输出当前默认时区
        final TimeZone zone = TimeZone.getTimeZone("GMT+8"); //获取中国时区
        TimeZone.setDefault(zone); //设置时区
        System.out.println(TimeZone.getDefault()); //
        // 上面是让时间正常
        String path = "G:\\虫子数据\\顺丰虫子\\虫子";
        String[] fileList = new File(path).list();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

        Date date1 = new Date();
        System.out.println(date1);
        FileInfo fileInfo = new FileInfo();
        for (String fileNnameTmp: fileList) {
            String prefix = fileNnameTmp.substring(0, fileNnameTmp.lastIndexOf("."));
            int num = Integer.parseInt(prefix.substring(14, 17));
            int type = Integer.parseInt(prefix.substring(17, 18));
            Date date = null;
            try{
                date = sdf.parse(prefix.substring(0, 14));
            }catch (ParseException e){
                e.printStackTrace();
            }
            String reserve = fileNnameTmp.substring(18);
            System.out.println(prefix + " " + prefix.length() + " " + date + " " + num + " " + type +  " " + reserve);

            fileInfo.setFilename(prefix);

            fileInfo.setFileType(1);
            fileInfo.setInDateTime(date1);
            fileInfo.setFence(1);
            fileInfo.setIsDelete(0);
            fileInfoDao.insertFileInfo(fileInfo);
            System.out.println(fileInfoDao.insertFileInfo(fileInfo));

        }

    }

    @Test
    @Ignore
    public void updateFileInfoById() {
    }

    @Test
    @Ignore
    public void updateFileInfoByFilename() {

    }

    @Test
    @Ignore
    public void deleteFileInfo() {

    }

    @Test
    public void queryFileInfoListOnlyFilename() {
        String path = "D:\\2020\\slideway-test";
        List<String> systemFileList = Arrays.asList(new File(path).list());
        List<String> datasetFileList = fileInfoDao.queryFileInfoListOnlyFilename();
        Map<String, String> dataMap = new HashMap<String, String>();
        List<String> newDataList = new ArrayList<>();
        if(datasetFileList != null && !systemFileList.isEmpty()){
            System.out.println("数据库记录" + datasetFileList.size());
            for (String filename : datasetFileList){
                dataMap.put(filename, filename);
                System.out.println(filename);
            }
            System.out.println("______________");
            System.out.println("系统文件" + systemFileList.size());
            for(String filename: systemFileList){
                if(!dataMap.containsKey(filename)){
                    newDataList.add(filename);
                }
                System.out.println(filename);
            }
        }
        System.out.println("______________");
        System.out.println(newDataList.size());
        for(String filename: newDataList){
            System.out.println(filename);
        }


    }
}