package com.wsn640.slidewaydatainterface.tool;

import com.wsn640.slidewaydatainterface.entity.FileInfo;

import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Tool {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    private static String zipDir = "E:\\2020\\slidewayzip_dir";

    private static final int BUFFER_SIZE = 2 * 1024;

    public static FileInfo decodeFilename(String filename){
        String prefix = filename.substring(0, filename.lastIndexOf("."));
        int fence = Integer.parseInt(prefix.substring(14, 17));
        int type = Integer.parseInt(prefix.substring(17, 18));
        int isDelete = 0;
        Date date = null;
        try{
            date = sdf.parse(prefix.substring(0, 14));
        }catch (ParseException e){
            e.printStackTrace();
        }
        return new FileInfo(filename, date, fence, type, isDelete);
    }




    /**
     * 压缩成ZIP
     * @param filenameList 需要压缩的文件路径
     * @param filenameList 需要压缩的文件名列表
     * @param out      压缩文件输出流
     * @throws RuntimeException 压缩失败会抛出运行时异常
     */
    public static void toZip(String srcPath, List<String> filenameList, OutputStream out) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (String filename : filenameList) {
                File srcfile = new File(srcPath + "/"  + filename);
                byte[] buf = new byte[BUFFER_SIZE];
                zos.putNextEntry(new ZipEntry(srcfile.getName()));
                int len;
                FileInputStream in = new FileInputStream(srcfile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            long end = System.currentTimeMillis();
            System.out.println("压缩完成，耗时：" + (end - start) + " ms");
        } catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        } finally {
            if (zos != null) {
                try {
                    zos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 生成压缩文件
     * @param srcPath
     * @param filenameList
     * @return
     */
    public static String toZipFile(String srcPath, List<String> filenameList){
        String zipname = sdf.format(new Date()) + ".zip";
        File file = new File(zipDir + "/" + zipname);
        FileOutputStream fos = null;

        try {

            fos = new FileOutputStream(file); //将FileOutputStream流对象连接到file1代表的文件
            toZip(srcPath, filenameList, fos);

        } catch (IOException e) {

            e.printStackTrace();

        } finally {

            if( fos != null )
                try {
                    fos.close(); //关闭流
                } catch (IOException e) {
                    e.printStackTrace();
                }
        }
        return zipname;
    }

    /**
     * 删除压缩文件
     * @param zipname
     */
    public static void deleteZip(String zipname){
        File file = new File(zipDir + "/" + zipname);
        file.delete();
    }


    /**
     * 拷贝文件
     *
     * @param oldFilePath 源文件
     * @param newPath 指定文件
     */
    public static void copyFile(String oldFilePath, String newPath) throws IOException {
        File oldFile = new File(oldFilePath);
        File file = new File(newPath);
        FileInputStream in = new FileInputStream(oldFile);
        FileOutputStream out = new FileOutputStream(file);;

        byte[] buffer=new byte[2097152];

        while((in.read(buffer)) != -1){
            out.write(buffer);
        }
        in.close();
        out.close();
    }

    public static void main(String[] args){
        deleteZip("20200605053616.zip");
    }


}
