package com.wsn640.slidewaydatainterface.config.schedule;

import com.wsn640.slidewaydatainterface.schedule.job.DemoJob;
import com.wsn640.slidewaydatainterface.schedule.job.SubscriberJob;
import com.wsn640.slidewaydatainterface.schedule.jobfactory.DemoAdaptableJobFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;

@Configuration
public class QuartzConfig {


    /**
     * 1.创建Job对象
     */
    @Bean
    public JobDetailFactoryBean jobDetailFactoryBean(){
        JobDetailFactoryBean factory = new JobDetailFactoryBean();
        //关联我们自己的Job类
//        factory.setJobClass(SubscriberJob.class);
        factory.setJobClass(DemoJob.class);

        return factory;
    }

    /**
     * 2.创建Trigger对象
     * 简单的Trigger
     */
    @Bean
    public SimpleTriggerFactoryBean simpleTriggerFactoryBean(JobDetailFactoryBean jobDetailFactoryBean){
        SimpleTriggerFactoryBean factory = new SimpleTriggerFactoryBean();
        //关联JobDetail对象
        factory.setJobDetail(jobDetailFactoryBean.getObject());
        //该参数表示一个执行的毫秒数
        // 2个钟执行一次
        factory.setRepeatInterval(1* 60 * 60 * 1000);
        //重复次数
        factory.setRepeatCount(-1);
        return factory;
    }

//    /**
//     * 3.创建Scheduler对象
//     */
//    @Bean
//    public SchedulerFactoryBean schedulerFactoryBean(SimpleTriggerFactoryBean simpleTriggerFactoryBean){
//        SchedulerFactoryBean factory = new SchedulerFactoryBean();
//        //关联trigger
//        factory.setTriggers(simpleTriggerFactoryBean.getObject());
//
//        return factory;
//    }

    /**
     * 3.创建Scheduler对象
     */
    @Bean
    public SchedulerFactoryBean schedulerFactoryBean(SimpleTriggerFactoryBean simpleTriggerFactoryBean, DemoAdaptableJobFactory demoAdaptableJobFactory){
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        //关联trigger
        factory.setTriggers(simpleTriggerFactoryBean.getObject());
        factory.setJobFactory(demoAdaptableJobFactory);
        return factory;
    }

}
