package com.wsn640.slidewaydatainterface.service.impl;

import com.wsn640.slidewaydatainterface.dao.FileInfoDao;
import com.wsn640.slidewaydatainterface.entity.FileInfo;
import com.wsn640.slidewaydatainterface.service.SlidewayDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class SlidewayDataServiceImpl implements SlidewayDataService {

//    @Value("${load_path}")
    @Value("G:\\虫子数据\\顺丰虫子\\虫子")
    private String fileDir;
    @Value("${date_time_pattern}")
    private String dateTimePattern;

    @Autowired
    private FileInfoDao fileInfoDao;

    @Override
    public String getFileDir() {
        return fileDir;
    }


    public String getResolutePath(String filename) {
        return fileDir + '/' + filename;
    }


    @Override
    public List<FileInfo> getAllSlidewayData() {
        return fileInfoDao.queryFileInfoList();
    }



    @Override
    public FileInfo decodeFilename(String filename) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimePattern);
        String prefix = filename.substring(0, filename.lastIndexOf("."));
        String dateStr = prefix.substring(0, 14);
        int fence = Integer.parseInt(prefix.substring(14, 17));
        int fileType = Integer.parseInt(prefix.substring(17, 18));
        Date inDateTime = null;
        try {
            inDateTime = sdf.parse(dateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            System.out.println("转换出错了:" + dateStr);
        }
        return new FileInfo(filename, inDateTime, fence, fileType, 0);
    }


    @Transactional
    @Override
    public List<FileInfo> checkNewFileList() {
        List<String> newFilenameList = getNewFileList();
        List<FileInfo> newFileInfoList = new ArrayList<FileInfo>();
        for (String filename : newFilenameList
        ) {
            newFileInfoList.add(decodeFilename(filename));
        }

        return newFileInfoList;
    }


    @Transactional
    @Override
    public List<String> getNewFileList() {
        List<String> systemFileList = Arrays.asList((new File(fileDir)).list());
        List<String> datasetFileList = fileInfoDao.queryFileInfoListOnlyFilename();
        Map<String, String> dataMap = new HashMap<String, String>();
        List<String> newDataList = new ArrayList<>();
        if (datasetFileList != null && !systemFileList.isEmpty()) {
            System.out.println("数据库记录：" + datasetFileList.size());
            for (String filename : datasetFileList) {
                dataMap.put(filename, filename);
//                System.out.println(filename);
            }
            System.out.println("系统文件：" + systemFileList.size());
            for (String filename : systemFileList) {
                if (!dataMap.containsKey(filename)) {
                    newDataList.add(filename);
                }
//                System.out.println(filename);
            }
        }
        System.out.println("新增数据：" + newDataList.size());
//        for (String filename : newDataList) {
//            System.out.println(filename);
//        }
        return newDataList;
    }


    @Transactional
    @Override
    public void insertAllFileInfo() {
        System.out.println(fileDir);
        String[] fileList = new File(fileDir).list();
        for (String filename : fileList) {
            System.out.println(filename);
            fileInfoDao.insertFileInfo(decodeFilename(filename));
        }
    }

    @Transactional
    @Override
    public void insertNewFileInfo(List<FileInfo> newFileList) {
        for (FileInfo newFile : newFileList) {
            fileInfoDao.insertFileInfo(newFile);
        }
    }



}
