package com.wsn640.slidewaydatainterface.controller;

import com.wsn640.slidewaydatainterface.service.SubscriberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/subscriber") // 根路由
public class SubscriberController {

    @Autowired
    SubscriberService subscriberService;

    @RequestMapping(value="/register", method= RequestMethod.POST)
    public String register(String name, String ipPort){
        return subscriberService.registerSubscriber(name, ipPort);
    }

    @RequestMapping(value="/logout", method= RequestMethod.POST)
    public String logout(Integer id){
        return subscriberService.deleteSubscriber(id);
    }



}
