package com.wsn640.slidewaydatainterface.schedule.job;

import com.wsn640.slidewaydatainterface.entity.FileInfo;
import com.wsn640.slidewaydatainterface.entity.Subscriber;
import com.wsn640.slidewaydatainterface.service.SlidewayDataService;
import com.wsn640.slidewaydatainterface.service.SubscriberService;
import com.wsn640.slidewaydatainterface.tool.Tool;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SubscriberJob extends QuartzJobBean {

    @Autowired
    SlidewayDataService slidewayDataService;

    @Autowired
    SubscriberService subscriberService;

    private static String zipDir = "E:\\2020\\slidewayzip_dir";

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(sdf.format(new Date()));
        List<String> newFilenameList = slidewayDataService.getNewFileList();
        if(newFilenameList.size() > 0){
            List<FileInfo> newFileInfoList = new ArrayList<FileInfo>();
            for (String filename : newFilenameList
            ) {
                newFileInfoList.add(slidewayDataService.decodeFilename(filename));
            }
            slidewayDataService.insertNewFileInfo(newFileInfoList);
            List<Subscriber> subscriberList = subscriberService.getSubscriberList();
            if(subscriberList.size() > 0){
                String zipName = Tool.toZipFile(slidewayDataService.getFileDir(), newFilenameList);
                for (Subscriber subscriber: subscriberList) {
                    RestTemplate restTemplate = new RestTemplate();
                    FileSystemResource fileSystemResource = new FileSystemResource(zipDir + "/" + zipName);
                    HttpHeaders headers = new HttpHeaders();
                    MediaType type = MediaType.parseMediaType("multipart/form-data");
                    headers.setContentType(type);
                    MultiValueMap<String, Object> form = new LinkedMultiValueMap<String, Object>();
                    form.add("filename", zipName);
                    form.add("file", fileSystemResource);
                    HttpEntity<MultiValueMap<String, Object> > files = new HttpEntity<>(form, headers);
                    String s = restTemplate.postForObject(subscriber.getIpPort(), files, String.class);
                    System.out.println("______" + s);

                }
                Tool.deleteZip(zipName);
            }

        }

    }


}
