package com.wsn640.slidewaydatainterface.controller;

import com.wsn640.slidewaydatainterface.entity.FileInfo;
import com.wsn640.slidewaydatainterface.service.SlidewayDataService;
import com.wsn640.slidewaydatainterface.tool.Tool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/data") // 根路由
public class SlidewayDataControllor {

    @Autowired
    private SlidewayDataService slidewayDataService;

    @Value("${date_time_pattern}")
    private String dateTimePattern;

    @RequestMapping(value="/test", method=RequestMethod.GET)
    public String test(){
    // slidewayDataService.insertAllFileInfo();
      sendFilesTest();
      return "Test Finish!";
    }

    // 查询接口
    @RequestMapping(value = "/listSlidewayDataInfo", method = RequestMethod.GET)
    private Map<String, Object> listSlidewayDataInfo(){
        Map<String, Object> modelMap = new HashMap<String, Object>();
        List<FileInfo> list = slidewayDataService.getAllSlidewayData();
        modelMap.put("FileInfoList", list);
        return modelMap;
    }

//    @RequestMapping(value = "/querySlidewayDataByDate", method = RequestMethod.GET)
//    private Map<String, Object> querySlidewayDataByDate(){
//        Map<String, Object> modelMap = new HashMap<String, Object>();
//        List<FileInfo> list = slidewayDataService.getAllSlidewayData();
//        modelMap.put("FileInfoList", list);
//        return modelMap;
//    }

    // 拉取接口

//    @RequestMapping(value="/getAloneFile", method=RequestMethod.POST)
//    @ResponseBody
//    public void getFile(HttpServletRequest request, HttpServletResponse response){
//        String filename = request.getParameter(filename);
//        System.out.println(filename);
//
//
//    }

    @RequestMapping(value = "/getAloneFile", method = RequestMethod.GET)
    public ResponseEntity<FileSystemResource> getAloneFile(String filename) {
        return sendFile(new File(slidewayDataService.getFileDir() + "/" + filename));
    }


    @RequestMapping(value = "/getFileZip", method = RequestMethod.POST)
    public void getFileZip(@RequestBody List<String> filenameList, HttpServletResponse response) {

        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=uchainfile.zip");



        try {
            Tool.toZip(slidewayDataService.getFileDir(), filenameList, response.getOutputStream());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }




    // 封装的文件返回实体
    public ResponseEntity<FileSystemResource> sendFile(File file) {
        if (file == null) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=" + file.getName());
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", new Date().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));

        return ResponseEntity .ok() .headers(headers) .contentLength(file.length()) .contentType(MediaType.parseMediaType("application/octet-stream")) .body(new FileSystemResource(file));
    }


    // 测试接口

    /**
     * 用于 向订阅者 端口 发送文件测试
     */
    public void sendFilesTest(){
        final String filename = "202001040427090790000000.jpg";
        final String filepath = "E:/2020/slideway-test" + "/"  + filename;
        final String url = "http://localhost:8088/slideway/data/download";

        RestTemplate restTemplate = new RestTemplate();

        FileSystemResource fileSystemResource = new FileSystemResource(filepath);

        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("multipart/form-data");
        headers.setContentType(type);
        MultiValueMap<String, Object> form = new LinkedMultiValueMap<String, Object>();
        form.add("filename", filename);
        form.add("file", fileSystemResource);

        System.out.println("!!!!!!!!!!!!!");
        HttpEntity<MultiValueMap<String, Object> > files = new HttpEntity<>(form, headers);
        String s = restTemplate.postForObject(url, files, String.class);
        System.out.println(s);
    }

    /**
     * 用于 订阅者 端口 接收文件测试
     */
    @RequestMapping(value="/download", method= RequestMethod.POST)
    @ResponseBody
    public String downloadFiles(@RequestParam("file") MultipartFile file){
        System.out.println("有被访问到");
        final String filePath = "E:/2020/slideway-test2";
        boolean isCreate = createLocalFile(filePath, file);
        if(!isCreate){
            System.out.println("Create local file failed!");
            return "Create local file failed!";
        }
        System.out.println("Create local file successfully");

        return "Create local file successfully";

    }

    private boolean createLocalFile(String filePath, MultipartFile file) {
        File localFile = new File(filePath);
        //先创建目录
        localFile.mkdirs();

        String originalFilename = file.getOriginalFilename();
        String path = filePath+"/"+originalFilename;

        System.out.println("createLocalFile path = " + path);

        localFile = new File(path);
        FileOutputStream fos = null;
        InputStream in = null;
        try {

            if(localFile.exists()){
                //如果文件存在删除文件
                boolean delete = localFile.delete();
                if (delete == false){
                    System.out.println("Delete exist file \"" + path + "\" failed!!!");
                }
            }
            //创建文件
            if(!localFile.exists()){
                //如果文件不存在，则创建新的文件
                localFile.createNewFile();
                System.out.println("Create file successfully,the file is " + path);
            }

            //创建文件成功后，写入内容到文件里
            fos = new FileOutputStream(localFile);
            in = file.getInputStream();
            byte[] bytes = new byte[1024];

            int len = -1;

            while((len = in.read(bytes)) != -1) {
                fos.write(bytes, 0, len);
            }

            fos.flush();
            System.out.println("Reading uploaded file and buffering to local successfully!");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }finally {
            try {
                if(fos != null) {
                    fos.close();
                }
                if(in != null) {
                    in.close();
                }
            } catch (IOException e) {
                System.out.println("InputStream or OutputStream close error :" + e.toString());
                return false;
            }
        }
        return true;
    }

}
