package com.example.demo_image.entity.sys;

import com.alibaba.fastjson.annotation.JSONField;
import com.example.demo_image.entity.BaseEntity;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.InputStream;

/**
 * @author morningbear
 * @date 20.7.11
 */
@Slf4j
@Data
@Accessors(chain = true)
@Entity
@Table(name = "img_file")
public class FileEntity extends BaseEntity {

    /**
     * 上传后的文件名
     */
    @Column(name = "file_name")
    private String fileName;

    /**
     * 原文件名
     */
    @Column(name = "file_origin_name")
    private String fileOriginName;

    /**
     * 文件路径
     */
    @Column(name = "file_path")
    private String filePath;

    /**
     * 文件大小
     */
    @Column(name = "file_size")
    private Long size;

    @Column(name = "file_type")
    private String fileType;

    /**
     * 文件内容
     */
    @JSONField(serialize = false)
    @Transient
    private InputStream content;
}
