package com.example.demo_image.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @author morningbear
 * @date 20.7.14
 */
@EnableSwagger2
@SpringBootConfiguration
public class SwaggerUiConfig {

    private Boolean enableSwaggerUi = Boolean.FALSE;

    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment){
        this.environment = environment;

        Profiles profiles = Profiles.of("dev", "test");
        enableSwaggerUi = environment.acceptsProfiles(profiles);
    }
    @Bean("clientAPI")
    public Docket clientApi(){
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("客户端")
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.example.demo_image.controller.api"))
                .paths(PathSelectors.any())
                .build()
                .apiInfo(apiInfo());
    }

    @Bean("adminAPI")
    public Docket adminApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .groupName("管理后台")
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.example.controller.admin"))
                .paths(PathSelectors.any())
                .build()
                .apiInfo(apiInfo());
    }

    /**
     * 功能描述：SwaggerUI文档的基本信息
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("骨架")
                .description("骨架 。。。施工中")
                .termsOfServiceUrl("http://127.0.0.1")
                .contact(new Contact("", "", ""))
                .version("v0.0.1")
                .build();
    }
}
