package com.example.demo_image.util;

import lombok.extern.slf4j.Slf4j;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author morningbear
 * @date 20.7.7
 */
@Slf4j
public class FileUtils {

    /**
     * 获取分隔符
     * @return fileSeparator
     */
    private static String getFileSeparator(){
        return System.getProperty("file.separator");
    }

    /**
     * 上传后的文件夹名
     * @return folderName
     */
    public static String getFolder(){
        return LocalDateTime.now().format(DateTimeFormatter
                .ofPattern("yyyy/MM/dd")) + getFileSeparator();
    }

    /**
     * 获取随机文件名
     * @return
     */
    public static String getFileName(){
        return UUIDUtil.getUid("FL_" , 17) ;
    }

    /**
     * 获取文件后缀
     * @param fileName 文件名
     * @return jpg/png/...
     */
    public static String getFileNameSub(String fileName){
        return fileName.substring(fileName.indexOf("."));
    }
}
