package com.example.demo_image.repository;

import com.example.demo_image.entity.sys.FileEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
 * @author morningbear
 * @date 20.7.11
 */
public interface FileRepository extends JpaRepository<FileEntity, Long> {

    /**
     * 根据图片文件名查询图片
     * @param filename 文件名
     * @return 与图片有关的记录
     */
    //@Query("select f from FileEntity f where f.fileName=:filename and f.isDel=false ")
    FileEntity findByFileName(@Param("filename") String filename);

    /**
     * 根据ID查找
     * @param id 图片id
     * @return 对应的图片
     */
    @Query("select f from FileEntity f where f.id=:id and f.isDel=false ")
    FileEntity findFileEntityById(@Param("id") String id);

    /**
     * 查询所有未删除的图片
     * @param of 分页请求
     * @return 所有的图片记录
     */
    @Query("select f from FileEntity f where f.isDel=false ")
    Page<FileEntity> findAll(PageRequest of);
}
