package com.example.demo_image.entity;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * @author morningbear
 * @date 20.7.11
 */
@Slf4j
@Data
@MappedSuperclass
public abstract class BaseEntity implements Serializable {

    /**
     *  记录标识
     */
    @Id
    @Column(name = "id")
    private String id;

    /**
     * 记录创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 记录修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 记录创建时间
     */
    @Column(name = "create_at")
    private Date createAt;

    /**
     * 记录修改时间
     */
    @Column(name = "update_at")
    private Date updateAt;

    /**
     * 记录是否被删除
     */
    @Column(name = "is_del")
    private Boolean isDel = Boolean.FALSE;
}
