package com.example.demo_image.vo.sys;

import com.alibaba.fastjson.annotation.JSONField;
import com.example.demo_image.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.io.InputStream;

/**
 * @author morningbear
 * @date 20.7.13
 */
@Data
@ApiModel("图片文件实体")
@Slf4j
@Accessors(chain = true)
public class FileVo extends BaseVo {

    @ApiModelProperty("上传后的文件名")
    private String fileName;

    @ApiModelProperty("原文件名")
    private String fileOriginName;

    @ApiModelProperty("文件大小")
    private Long size;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("图片")
    @JSONField(serialize = false)
    private InputStream content;

}
