package com.example.demo_image.dto;

import com.example.demo_image.util.FastJsonEnumSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;

import java.io.Serializable;

/**
 * @author morningbear
 * @date 20.7.11
 * @param <T>
 */
@Data
@Slf4j
@Accessors(chain = true)
@NoArgsConstructor
public class Result<T> implements Serializable {
    @JsonSerialize(using = FastJsonEnumSerializer.class)
    @ApiModelProperty("响应码")
    private HttpStatus code;

    @ApiModelProperty("描述")
    private String message;

    @ApiModelProperty("数据")
    private T data;

    public Result(HttpStatus code, String message, T data){
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Result result(HttpStatus code, String message, T data) {
        return new Result(code, message, data);
    }

    public Result ok() {
        return new Result(HttpStatus.OK, "操作成功", null);
    }

    public Result ok(String message) {
        return new Result(HttpStatus.OK, message, null);
    }

    public Result ok(T data) {
        return new Result(HttpStatus.OK, "", data);
    }

    public Result ok(String message, T data) {
        return new Result(HttpStatus.OK, message, data);
    }

    public Result serverError() {
        return new Result(HttpStatus.INTERNAL_SERVER_ERROR, "服务器异常", null);
    }

    public Result serverError(String message) {
        return new Result(HttpStatus.INTERNAL_SERVER_ERROR, message, null);
    }

    public Result serverError(T data) {
        return new Result(HttpStatus.INTERNAL_SERVER_ERROR, "", data);
    }

    public Result serverError(String message, T data) {
        return new Result(HttpStatus.INTERNAL_SERVER_ERROR, message, data);
    }

    public Result requestError(String message) {
        return new Result(HttpStatus.BAD_REQUEST, message, null);
    }
}
