package com.example.demo_image.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Date;

/**
 * @author morningbear
 * @date 20.7.7
 */
@ApiModel(value = "基本实体")
@Slf4j
@Data
@Accessors(chain = true)
public class BaseVo implements Serializable {

    @ApiModelProperty(value = "编号")
    @Resource
    private String id;

    @JsonIgnore
    private Long createBy;

    @JsonIgnore
    private Long updateBy;

    @JsonIgnore
    private Date createAt;

    @JsonIgnore
    private Date updateAt;
}
