'''
Author: zhuwanjie 2268677665@qq.com
Date: 2025-04-21 11:34:18
LastEditors: zhuwanjie 2268677665@qq.com
LastEditTime: 2025-04-30 09:56:59
FilePath: \unet-pytorch\demo.py
Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
'''
import os
import numpy as np
import cv2
from matplotlib import pyplot as plt
from scipy.fft import fft2, ifft2, fftshift, ifftshift


# 从 K 空间数据重建图像
def reconstruct_image(kspace_data):
    print("kspace_data shape:", kspace_data.shape) 
    im = fftshift(ifft2(kspace_data, (256, 256)), axes=0)  # 
    # 取模得到实值图像
    magnitude_image = np.abs(im)
    # 归一化图像
    normalized_image = (magnitude_image - magnitude_image.min()) / (magnitude_image.max() - magnitude_image.min())
    # 转换为 8 位无符号整数
    uint8_image = (normalized_image * 255).astype(np.uint8)
    # 转换为 RGB 图像
    rgb_image = cv2.cvtColor(uint8_image, cv2.COLOR_GRAY2RGB)
    return rgb_image


def saveImg(path, img):
    fig = plt.figure(figsize=(img.shape[1] / 100, img.shape[0] / 100), dpi=130)
    plt.imshow(img, cmap='gray')
    plt.axis('off')
    plt.savefig(path, bbox_inches='tight', pad_inches=0, transparent=True)
    plt.close(fig)


def process_kspace_folder(kspace_folder_path, output_folder_path):
    if not os.path.exists(output_folder_path):
        os.makedirs(output_folder_path)

    file_names = [f for f in os.listdir(kspace_folder_path) if f.endswith('.npy')]
    for file_name in file_names:
        kspace_file_path = os.path.join(kspace_folder_path, file_name)
        kspace_data = np.load(kspace_file_path)

        # 重建图像
        reconstructed_image = reconstruct_image(kspace_data)

        # 保存重建后的图像
        output_file_name = os.path.splitext(file_name)[0] + '_reconstructed.png'
        output_file_path = os.path.join(output_folder_path, output_file_name)
        saveImg(output_file_path, reconstructed_image)


if __name__ == "__main__":
    kspace_folder_path = r'D:\Users\Desktop\fid' # 请替换为实际的k空间数据文件夹路径
    output_folder_path = r'D:\Users\Desktop\img'  # 请替换为实际的输出文件夹路径
    process_kspace_folder(kspace_folder_path, output_folder_path)
