import cv2
import os
import re


def natural_sort_key(s):
    return [int(text) if text.isdigit() else text.lower() for text in re.split('([0-9]+)', s)]


def images_to_video(image_folder, video_name, fps=24, target_width=640, target_height=480):
    # 支持更多图片格式
    supported_extensions = ('.png', '.jpg', '.jpeg', '.bmp')
    images = [img for img in os.listdir(image_folder) if img.endswith(supported_extensions)]
    images.sort(key=natural_sort_key)

    if not images:
        print("未找到图片文件。")
        return

    fourcc = cv2.VideoWriter_fourcc(*'mp4v')
    video = cv2.VideoWriter(video_name, fourcc, fps, (target_width, target_height))

    for image in images:
        img_path = os.path.join(image_folder, image)
        try:
            frame = cv2.imread(img_path)
            if frame is None:
                print(f"无法读取图片: {img_path}")
                continue
            # 调整图片尺寸
            resized_frame = cv2.resize(frame, (target_width, target_height))
            video.write(resized_frame)
        except Exception as e:
            print(f"处理图片 {img_path} 时出错: {e}")

    video.release()
    print(f"视频 {video_name} 已生成。")


if __name__ == "__main__":
    image_folder = r'D:\Users\Desktop\item\unet-pytorch\img'  # 替换为实际的图片文件夹路径
    video_name = 'output_video.mp4'
    fps = 1
    # 设置目标尺寸
    target_width = 640
    target_height = 640
    images_to_video(image_folder, video_name, fps, target_width, target_height)
    