'''
Author: zhuwanjie 2268677665@qq.com
Date: 2025-03-18 16:12:12
LastEditors: zhuwanjie 2268677665@qq.com
LastEditTime: 2025-03-25 11:10:39
FilePath: \egg\masksshow.py
Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
'''
import numpy as np
import os

def calculate_sampling_rate(mask):
    total_elements = mask.size
    sampled_elements = np.count_nonzero(mask)
    sampling_rate = sampled_elements / total_elements
    return sampling_rate

# 设置当前工作目录
current_dir = os.getcwd()

# 遍历当前目录下的所有 .npy 文件
for filename in os.listdir(current_dir):
    if filename.lower().endswith('.npy'):
        mask_path = os.path.join(current_dir, filename)
        try:
            mask = np.load(mask_path)
            sampling_rate = calculate_sampling_rate(mask)
            print(f"文件 {filename} 的采样率为: {sampling_rate * 100:.2f}%")
        except Exception as e:
            print(f"错误: 加载文件 {mask_path} 时出错: {e}")



