'''
Author: zhuwanjie 2268677665@qq.com
Date: 2025-04-01 14:25:09
LastEditors: zhuwanjie 2268677665@qq.com
LastEditTime: 2025-04-23 16:47:03
FilePath: \egg\tess.py
Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
'''
#import cv2
#import numpy as np


#img1 = cv2.imread(r'D:\Users\Desktop\egg\pic\originalK.png')
#img2 = cv2.imread(r'D:\Users\Desktop\egg\pic\original.png')
#concatenated_img = cv2.hconcat([img1, img2])
#output_path = 'concatenated_image.jpg'
#cv2.imwrite(output_path, concatenated_img)
#cv2.imshow('Concatenated Image', concatenated_img)



# 等待按键退出
#cv2.waitKey(0)
#cv2.destroyAllWindows()
import numpy as np
import matplotlib.pyplot as plt


def generate_radial_mask(shape, num_lines):
    """
    生成径向采样掩码

    :param shape: 掩码的形状，通常为 (height, width)
    :param num_lines: 径向线的数量
    :return: 二进制类型的径向采样掩码
    """
    # 获取图像的中心
    center_y, center_x = np.array(shape) // 2
    y, x = np.indices(shape)
    # 创建一个全零的掩码
    mask = np.zeros(shape, dtype=bool)

    # 生成径向线的角度
    angles = np.linspace(0, 2 * np.pi, num_lines, endpoint=False)

    for angle in angles:
        # 计算径向线上的点
        t = np.linspace(-max(shape), max(shape), 1000)
        line_x = center_x + t * np.cos(angle)
        line_y = center_y + t * np.sin(angle)

        # 筛选出在图像范围内的点
        valid_x = (line_x >= 0) & (line_x < shape[1])
        valid_y = (line_y >= 0) & (line_y < shape[0])
        valid_indices = valid_x & valid_y

        # 将径向线上的点对应的掩码位置设为 True
        mask[line_y[valid_indices].astype(int), line_x[valid_indices].astype(int)] = True

    # 将布尔类型的掩码转换为二进制数值类型（np.uint8）
    binary_mask = mask.astype(np.uint8)
    return binary_mask


# 设置掩码的形状和径向线的数量
shape = (256, 256)
num_lines = 50

# 生成二进制类型的径向采样掩码
mask = generate_radial_mask(shape, num_lines)

# 可视化掩码
plt.figure(figsize=(8, 8))
plt.imshow(mask, cmap='gray')
plt.title('Radial Sampling Mask')
plt.axis('off')
plt.show()

# 保存为 .npy 文件
np.save('radial_mask.npy', mask)
